#include "msp430afe253.h"
#include "Segment_LCD.h"
#include "Menu.h"

#include <stdint.h>
#include "..\meter-toolkit\emeter-toolkit.h"

#include "io.h"

#include <emeter-toolkit.h>
#include "..\meter-ng\emeter-structs.h"


#include "LCD.h"
extern void bin2bcd32(unsigned char bcd[5], unsigned long bin);
extern void bin2bcd16(unsigned char bcd[3], unsigned int bin);
unsigned char LCDBuf[10] ;          // Ŀǰûõ S1/2/3/17/18/19/20/21/22/23/24
//----------------------------------------------------------------------------//
//-----------------------ӦӲ״̬й---------------------------//
//----------------------------------------------------------------------------//
//-----------------Ӳ״̬,BufSegӦϵ----------------------//
//     Buf      | BU9769FS_SEG   LCD_SEG    |   BU9769FS_SEG   LCD_SEG        //
//   LCDBuf[0]  |      1            1       |       2             2           //
//   LCDBuf[1]  |      3            3       |       4             4           //
//   LCDBuf[2]  |      5            5       |       6             6           //
//   LCDBuf[3]  |      7            7       |       8             8           //
//   LCDBuf[4]  |      9            9       |      10            10           //
//   LCDBuf[5]  |     11           11       |      12            12           //
//   LCDBuf[6]  |     13           13       |      14            14           //
//   LCDBuf[7]  |     15           15       |      16            16           //
//   LCDBuf[8]  |     17           17       |      18            18           //
//   LCDBuf[9]  |     19           19       |                                 //
//----------------------------------------------------------------------------//
//--------------------УʹõMCU-------------------------//
//     | S1 | S2 | S3 | S4 | S5 | S6 | S7 | S8 | S9 | S10 | S11 | S12 | S13 | S14 | S15 | S16 | S17 | S18 | S19 | S20 | S21 | S22 | S23 |
//COM1 | 6A | 6F | 5A | 5F |COL2| 4A | 4F | 3A | 3F | S17 | 2A  | 2F  | 1A  | 1F  | S2  | S8  | S9  | S16 | S26 |                   COM1  
//COM2 | 6B | 6G | 5B | 5G | S20| 4B | 4G | 3B | 3G | COL1| 2B  | 2G  | 1B  | 1G  | S3  | S7  | S10 | S15 | S25 |             COM2
//COM3 | 6C | 6E | 5C | 5E | S21| 4C | 4E | 3C | 3E |     | 2C  | 2E  | 1C  | 1E  | S1  | S6  | S11 | S14 | S24 |       COM3
//COM4 | 6D | P6 | 5D | P5 | S22| 4D | P4 | 3D | P3 | S18 | 2D  | P2  | 1D  | P1  | S4  | S5  | S12 | S13 | S23 | COM4
//----------------------------------------------------------------------------//
//unsigned char const ClrPor[] = 
//{
//      0x06,             // 'r'
//      0xc6,             // 'o'
//      0x03,             // 'P'
//      0x70,
//      0x60,             // 'r'
//      0x85,             // 'l'
//      0x97,             // 'P'
//      0x00,
//      0x00,
//      0x00,
//};
unsigned char const ClrPor[] = 
{
      0x06,             // 'r'
      0x36,             // 'o'
      0x0c,             // 'P'
      0xe0,
      0x60,             // 'r'
      0x1a,             // 'l'
      0x9a,             // 'P'
      0x00,
      0x00,
      0x00,
};

//           _________________________________________
//          |1  2  3  4  5  6 |
//           ___________________LCD___________________
//
//  ַת
// IIC ʱȷλٷλ
//            


unsigned char const LcdValue[] = 
{
    0xFA,                // '0'   0xFA 
    0x60,                // '1'   0x06
    0xD6,                // '2'   0x6D
    0xF4,                // '3'   0x4F
    0x6C,                // '4'   0x6C
    0xBC,                // '5'   0xCB
    0xBE,                // '6'   0xEB
    0xE0,                // '7'   0x0E
    0xFE,                // '8'   0xEF
    0xFC,                // '9'   0xCF
    0x00,                // ȫ
};



unsigned char const month_length[13] =
{
    00,
    31, 28, 31,
    30, 31, 30,
    31, 31, 30,
    31, 30, 31
};

/**/
updata_buf_s   updata;
rtc_t rtc_temp;
unsigned char  position = 5;       // ˸λ 
unsigned char  UpdataFg = UPDATA_NONE;
unsigned char  AdjustCnt = 0;


void bin2bcd32(unsigned char bcd[5], unsigned long bin);

/* LCD */
void ClrLCDRAM(void)
{
    unsigned char i ;
    for(i=0;i<10;i++)
    {
        LCDBuf[i] = 0;
    }
}


/*  λ */
/* longתBCDΪ10λ֣LCDʾΪ6λ֣ 
** мпܻõ߼λս6λ
** ΪΪ6λ6λ
*/
void ClrRedundancyZero(void)
{
    unsigned char *p;
    if(updata.bit32_flg){                          // long
        p = updata.buf.u32;                        // updata.buf.u32[0]
        p +=2;}                                    // updata.buf.u32[2]
    else{                                          // int
        p = updata.buf.u16;}                       // updata.buf.u16[0]
    
    if(((*p)&0xf0)==0){                            // СλP4  type: xxx.xxx
        LCDBuf[6] &= ~(0xfe);                      // λ"0"ʾ
        if(((*p)&0x0f)==0){
            LCDBuf[5] &= ~(0xfe);                  // ߶λ"0"ʾ
            if(LCDBuf[1]&Flg_P5){
                p++;
                if(((*p)&0xf0)==0){                // СλP5  type: xxxx.xx
                    LCDBuf[3] &= ~(0x0f);          // λ"0"ʾ 
                    LCDBuf[4] &= ~(0xe0);}}}}
    else{                                          // others뱾֧Ϊ
        __no_operation();}
}


void UpDataLCDRAM(void)
{
    unsigned char *p;
    
    switch(updata.bit32_flg)
    {
    case E_PRM_16BITS:  //  parameters 16bits
        p = (updata.buf.u16 + 2);
        break;
    case E_PRM_32BITS:  //  parameters 32bits
        p = (updata.buf.u32 + 4);
        break;
    case RTC_HHMMSS:    // RTC parameters hh:ss:mm
    case RTC_YMD:       // RTC parameters year:month:second
        p = (updata.buf.u16 + 2);
        break;
    default:
        break;
    }
    
    LCDBuf[0] |= LcdValue[(*p & 0x0f)];            // һ
    LCDBuf[1] |= LcdValue[((*p & 0xf0) >> 4)];     // BCD봦 Ҷ
    p--;
    LCDBuf[2] |= LcdValue[(*p & 0x0f)]>>4;         // 
    LCDBuf[3] |= LcdValue[(*p & 0x0f)]<<4;         // 
    LCDBuf[3] |= LcdValue[((*p & 0xf0) >> 4)]>>4;  // 
    LCDBuf[4] |= LcdValue[((*p & 0xf0) >> 4)]<<4;  // 
    p--;
    LCDBuf[5] |= LcdValue[(*p & 0x0f)];     // 
    LCDBuf[6] |= LcdValue[((*p & 0xf0) >> 4)];     // 
    
    if((updata.bit32_flg==E_PRM_16BITS)||(updata.bit32_flg==E_PRM_32BITS))
    {
        /* £"0" */
        ClrRedundancyZero();
    }
    /* ˢLCD */
    //   Segment_Display(0,LCDBuf,10);
}

/*Чѹ*/
void UpdataVrms(void)
{
    UpdataFg = UPDATA_V;
    updata.bit32_flg = E_PRM_16BITS;
    bin2bcd16(updata.buf.u16, chan1.V_rms);   // ȡֵ+ת
    ClrLCDRAM();                              // 建
    LCDBuf[8] |= Flg_V;                       // ѹ
    LCDBuf[1] |= Flg_P5;                      // СP5
    UpDataLCDRAM();
}

/*Ч*/
void UpdataIrms(void)
{
    UpdataFg = UPDATA_I;
    updata.bit32_flg = E_PRM_32BITS;
    bin2bcd32(updata.buf.u32,chan1.I_rms[0]);
    ClrLCDRAM();                               // 建
    LCDBuf[8] |= Flg_I;                        // 
    LCDBuf[3] |= Flg_P4;                       // СP4
    UpDataLCDRAM();
}

void UpdataConsumedPower(void)
{
    unsigned long temp;
    UpdataFg = UPDATA_ConsumerdPower;
    updata.bit32_flg = E_PRM_32BITS;
    
    temp = *(unsigned long*)P_ENERGY_ADD;
    temp += phase->energy.total_consumed_energy;
    if(temp>=15999999)                      // 10000 * 1600
    {
        temp = temp%15999999;
        _DINT();
        flash_clr((int *)P_ENERGY_ADD);    // ʷ洢
        flash_write_int32((long *)P_ENERGY_ADD, temp);    //write total_consumed_energy 
        FCTL1 = FWKEY;                      /* Erase, write = 0 */
        FCTL3 = FWKEY | LOCK;
        _EINT();
    }
    temp = temp/DEFAULT_POWERCONST_1;
    
    bin2bcd32(updata.buf.u32,temp);            // bcdת
    
    ClrLCDRAM();                               // 建
    LCDBuf[8] |= Flg_KWh;                        // 
    LCDBuf[1] |= Flg_P5;                      // СP5
    UpDataLCDRAM();
}

void UpdataClrPor(void)
{
    unsigned char *p;
    unsigned char i;
    p = (unsigned char *)ClrPor;
    UpdataFg = UPDATA_ClrPor;
    ClrLCDRAM();
    for(i=0;i<10;i++)
    {
        LCDBuf[i] = *p++;
    }
//    LCDBuf[0] = * (unsigned char *)ClrPor;
}
/*Ƶ*/
void UpdataFrquency(void)
{  
    UpdataFg = UPDATA_F;
    bin2bcd16(updata.buf.u16,chan1.frequency);
    updata.bit32_flg = E_PRM_16BITS;
    ClrLCDRAM();                               // 建
    LCDBuf[7] |= Flg_Hz;                       // Ƶʱ
    LCDBuf[1] |= Flg_P5;                       // СP5
    UpDataLCDRAM();
}

/*й*/
void UpdataActPower(void)
{
    long temp;
    UpdataFg = UPDATA_ActPower;
    updata.bit32_flg = E_PRM_32BITS;
    ClrLCDRAM();                                // 建
    if(chan1.active_power[0] < 0x80000000)
    {
        temp = chan1.active_power[0];
    }
    else
    {
        temp = -chan1.active_power[0];
        LCDBuf[6] |= Flg_P1;                      
    }
    bin2bcd32(updata.buf.u32,temp);
    LCDBuf[8] |= Flg_W;                         // Ƶʱ
    LCDBuf[1] |= Flg_P5;                        // СP5
    UpDataLCDRAM();
}

/*޹*/
void UpdataReactPower(void)
{
    long temp;
    UpdataFg = UPDATA_ReactPower;
    updata.bit32_flg = E_PRM_32BITS;
    ClrLCDRAM();                                // 建
    if(chan1.reactive_power[0] < 0x80000000)
    {
        temp = chan1.reactive_power[0];
    }
    else
    {
        temp = -chan1.reactive_power[0];
        LCDBuf[6] |= Flg_P1;                      
    }
    bin2bcd32(updata.buf.u32,temp);
    LCDBuf[7] |= Flg_var;                        // Ƶʱ
    LCDBuf[1] |= Flg_P5;                         // СP5
    UpDataLCDRAM();
}

/*ڹ*/
void UpdataApparentPower(void)
{
    long temp;
    UpdataFg = UPDATA_ApparentPower;
    updata.bit32_flg = E_PRM_32BITS;
    ClrLCDRAM();                                // 建
    if(chan1.apparent_power[0] < 0x80000000)
    {
        temp = chan1.apparent_power[0];
    }
    else
    {
        temp = -chan1.apparent_power[0];
        LCDBuf[6] |= Flg_P1;                      
    }
    bin2bcd32(updata.buf.u32,temp);
    LCDBuf[8] |= Flg_VA;                          // ڹʱ
    LCDBuf[1] |= Flg_P5;                          // СP5
    UpDataLCDRAM();
}

void UpdataPowerfct(void)
{
    int temp;
    UpdataFg = UPDATA_Powerfct;
    ClrLCDRAM();                                   // 建
    if(chan1.power_factor[0]<0x8000)
    {
        temp = chan1.power_factor[0]/10;
    }
    else
    {
        temp = -chan1.power_factor[0];
        temp = temp/10;
        LCDBuf[6] |= Flg_P1;                      
    }
    bin2bcd16(updata.buf.u16,temp);
    updata.bit32_flg = E_PRM_16BITS;
    LCDBuf[7] |= Flg_PowerFct;                     // 
    LCDBuf[3] = Flg_P4;                            // СP4
    UpDataLCDRAM();
}

void UpdataRTC1(unsigned char *rtc_prt)                // ʱ
{
    unsigned char temp[3];
    UpdataFg = UPDATA_RTC1; 
    
    bin2bcd16(temp, *(rtc_prt+3));
    updata.buf.u16[0] = temp[2];
    bin2bcd16(temp, *(rtc_prt+4));
    updata.buf.u16[1] = temp[2];
    bin2bcd16(temp, *(rtc_prt+5));
    updata.buf.u16[2] = temp[2];
    
    updata.bit32_flg = RTC_HHMMSS;
    ClrLCDRAM();                                    // 建
    LCDBuf[4] |= COL1;                              // ð
    LCDBuf[2] |= COL2;
    UpDataLCDRAM();
}

void UpdataRTC2(unsigned char *rtc_prt)                // ʱ
{ 
    unsigned char temp[3];
    
    UpdataFg = UPDATA_RTC2; 
    bin2bcd16(temp, *rtc_prt);
    updata.buf.u16[0] = temp[2];
    bin2bcd16(temp, *(rtc_prt+1));
    updata.buf.u16[1] = temp[2];
    bin2bcd16(temp, *(rtc_prt+2));
    updata.buf.u16[2] = temp[2];
    
    updata.bit32_flg = RTC_YMD;
    ClrLCDRAM();                                     // 建
    LCDBuf[4] |= Flg_P3;                             
    LCDBuf[1] |= Flg_P5;
    UpDataLCDRAM();
}

void AnalysisData(unsigned char dis_type)
{
    /* ˢǰ */
    for(unsigned char i=0;i<5;i++)
    {
        updata.buf.u32[i] = 0;
    }
    switch(dis_type)
    {
    case UPDATA_V:
        UpdataVrms();
        break;
    case UPDATA_I:
        UpdataIrms();
        break;
    case UPDATA_F:
        UpdataFrquency();
        break;
    case UPDATA_ActPower:
        UpdataActPower();
        break;
    case UPDATA_ReactPower:
        UpdataReactPower();
        break;
    case UPDATA_ApparentPower:
        UpdataApparentPower();
        break;
    case UPDATA_Powerfct:
        UpdataPowerfct();
        break;
    case UPDATA_ConsumerdPower:
        UpdataConsumedPower();
        kbStatus = 3;          //л Tab3ʷѡ   20110510
        break;
    default :
        __no_operation();
        break;
    }
}

void AnalysisRTC(unsigned char dis_tpye)
{
    switch(dis_tpye)
    {
    case RTC_TYPE1:                          // hh:mm:ss
        UpdataRTC1((unsigned char*)&rtc);
        break;
    case RTC_TYPE2:                          // year:month:day
        UpdataRTC2((unsigned char*)&rtc);
        break;
    default:
        __no_operation();
        break;
    }
    __no_operation();
}

void RTCAssign(void)        // ʱ丳ֵ
{
    rtc_temp.second = rtc.second;   // ǰʱϢ
    rtc_temp.minute = rtc.minute;
    rtc_temp.hour = rtc.hour;
    rtc_temp.day = rtc.day;
    rtc_temp.month = rtc.month;
    rtc_temp.year = rtc.year;
}


void FlashLCD()    // ǰ˸λ
{
    unsigned char temp[3];
    if(menustatu.flash_en)                            // ˸   ʱӵ״̬
    {
        bin2bcd16(temp, rtc_temp.reserved);     // BCDת 
        switch(position)
        {
        case POSITION_R1:                         // 1
        case POSITION_R2:                         // 2
            if(menustatu.flash_light){
                menustatu.flash_light = 0;
                LCDBuf[0] &=~0xfe;           // ʾֵ
                LCDBuf[1] &=~0xfe;}          // ʾֵ
            else{
                menustatu.flash_light = 1;
                LCDBuf[0] |= LcdValue[(temp[2] & 0x0f)];             // һ
                LCDBuf[1] |= LcdValue[((temp[2] & 0xf0) >> 4)];}     // BCD봦 Ҷ
            break;
        case POSITION_R3:                         // 3
        case POSITION_R4:                         // 4 
            if(menustatu.flash_light){
                menustatu.flash_light = 0;
                LCDBuf[2] &= ~0x0f;
                LCDBuf[3] &= ~0x0f;
                LCDBuf[3] &= ~0xe0;
                LCDBuf[4] &= ~0xe0;}
            else{
                menustatu.flash_light = 1;
                LCDBuf[2] |= LcdValue[(temp[2] & 0x0f)]>>4;          // 
                LCDBuf[3] |= LcdValue[(temp[2] & 0x0f)]<<4;          // 
                LCDBuf[3] |= LcdValue[((temp[2] & 0xf0) >> 4)]>>4;   // 
                LCDBuf[4] |= LcdValue[((temp[2] & 0xf0) >> 4)]<<4;}  // 
            break;
        case POSITION_R5:                                       // 5
        case POSITION_R6:                                       // 6
            if(menustatu.flash_light){
                menustatu.flash_light = 0;
                LCDBuf[5] &=~0xfe;                              // ʾֵ
                LCDBuf[6] &=~0xfe;}                             // ʾֵ
            else{
                menustatu.flash_light = 1;
                LCDBuf[5] |= LcdValue[(temp[2] & 0x0f)];             // 
                LCDBuf[6] |= LcdValue[((temp[2] & 0xf0) >> 4)];}     // 
            break;  
        default:
            break;
        }
    }
    else                 //  ˢ״̬
    {
        UpDataDisInfo(UpdataFg);
    }
    /* ˢLCD */
    Segment_Display(0,LCDBuf,10);
    __no_operation();
}

/* RTCʼ˸ */
void StartFlashing(void)
{
    menustatu.flash_en = 1;  //
}

/* RTCϣֹͣ˸ */
void StopFlashing(void)
{
    menustatu.flash_en = 0;   //
}

/* RTCȷ */
void EnsureRTC(void)
{
    AdjustCnt = 0;                  // ȷʱ䣬¼
    rtc.second = rtc_temp.second;   // ǰʱϢ
    rtc.minute = rtc_temp.minute;
    rtc.hour = rtc_temp.hour;
    rtc.day = rtc_temp.day;
    rtc.month = rtc_temp.month;
    rtc.year = rtc_temp.year;    
    rtc.sumcheck = ((~(rtc.second + rtc.minute + rtc.hour + rtc.day + rtc.month + rtc.year)) & 0xFF);
    StopFlashing();
    if(rtc_state == RTC_TYPE1)
    {
        UpdataRTC1((unsigned char*)&rtc);                // ʱ
    }
    else
    {
        UpdataRTC2((unsigned char*)&rtc);                // 
    }
}

void BackLightCtrl(void)
{
    P1OUT ^= BIT2 ;     // P1.2Ϊƽ
}

void AdjustNextPRM(void) // һRTCʱ
{
    unsigned char  *p;
    AdjustCnt ++ ;
    position = 1;
    p = (unsigned char*)&rtc_temp;
    if(rtc_state == RTC_TYPE1)
    {
        if(AdjustCnt ==3)       // ʱ
        {
            kbStatus = 0;   // ˵תһ
            AdjustCnt = 0;
            menustatu.adjust_fg = 0;                                  //  
            rtc_state = RTC_TYPE1;
            UpdataRTC1((unsigned char*)&rtc);                // ʱ
            StopFlashing(); 
        }
        else
        {
            menustatu.adjust_fg = 1;      
            StartFlashing();
            rtc_state = RTC_TYPE2;
            UpdataRTC2((unsigned char*)&rtc_temp);                // 
            p = p+2;
        }
    }
    else if(rtc_state == RTC_TYPE2)
    {
        if(AdjustCnt ==3)       // ʱ
        {
            kbStatus = 0;   // ˵תһ
            AdjustCnt = 0;
            menustatu.adjust_fg = 0;                                   //  
            rtc_state = RTC_TYPE2;
            UpdataRTC2((unsigned char*)&rtc);                // ʱ
            StopFlashing(); 
        }
        else
        {
            menustatu.adjust_fg = 1;     
            StartFlashing();
            rtc_state = RTC_TYPE1;
            UpdataRTC1((unsigned char*)&rtc_temp);                // ʱ
            p = p+5;
        }
    }
    if(AdjustCnt !=3)
    {
        switch(position)
        {
        case POSITION_R1:
            rtc_temp.reserved = *p;
            break;
        case POSITION_R3:                         // 2
            rtc_temp.reserved = *(p-1);
            break;
        case POSITION_R5:
            rtc_temp.reserved = *(p-2);
            break;
        default:
            break;
        }
    }
    Segment_Display(0,LCDBuf,10);            // ˢ
    __no_operation();
}

/* RTCʱȷλãĸ˸ */
void ShiftCtrl(void)
{
    unsigned char  *p;
    p = (unsigned char*)&rtc_temp;
    position =position+2 ;       // λλ
    if(position ==POSITION_END)
    {
        position = POSITION_R1;
    }
    
    if(rtc_state == RTC_TYPE1)
    {
        UpdataRTC1((unsigned char*)&rtc_temp);                // ʱ
        p = p+5;
    }
    else
    {
        UpdataRTC2((unsigned char*)&rtc_temp);                // 
        p = p+2;
    }
    switch(position)
    {
    case POSITION_R1:
        rtc_temp.reserved = *p;
        break;
    case POSITION_R3:                         // 2
        rtc_temp.reserved = *(p-1);
        break;
    case POSITION_R5:
        rtc_temp.reserved = *(p-2);
        break;
    default:
        break;
    }
}

/* ʱ */
void RTCAdjust(void)
{
    if(rtc_state == RTC_TYPE1)
    {
        switch(position)
        {
        case POSITION_R1:                         // second
            rtc_temp.second++;
            if(rtc_temp.second==60)
            {
                rtc_temp.second = 0;
            }
            rtc_temp.reserved=rtc_temp.second;
            break;
        case POSITION_R3:                         // minute
            rtc_temp.minute++;
            if(rtc_temp.minute==60)
            {
                rtc_temp.minute = 0;
            }
            rtc_temp.reserved=rtc_temp.minute;
            break;
        case POSITION_R5:                         // hour
            rtc_temp.hour++;
            if(rtc_temp.hour==24) 
            {
                rtc_temp.hour = 0;
            }
            rtc_temp.reserved=rtc_temp.hour;
            break;
        default:
            break;
        }
    }
    else
    {
        switch(position)
        {
        case POSITION_R1:                         // day
            if ((rtc_temp.month == 2  &&  (rtc_temp.year & 3) == 0  &&  rtc_temp.day < 29)
                ||rtc_temp.day < month_length[rtc_temp.month])
            {
                rtc_temp.day++;
            }
            else
            {
                rtc_temp.day = 1;
            }
            rtc_temp.reserved=rtc_temp.day;
            break;
        case POSITION_R3:                         // month
            rtc_temp.month++;
            if(rtc_temp.month==13)
            {
                rtc_temp.month = 1;
            }
            rtc_temp.reserved=rtc_temp.month;
            break;
        case POSITION_R5:                         // year
            rtc_temp.year++;
            if(rtc_temp.year==100) 
            {
                rtc_temp.year = 0;
            }
            rtc_temp.reserved=rtc_temp.year;
            break;
        default:
            break;
        }
    }
}


void UpDataDisInfo(unsigned char updata_state)
{
    switch(updata_state)
    {
    case UPDATA_V:
        UpdataVrms();
        break;
    case UPDATA_I:
        UpdataIrms();
        break;
    case UPDATA_F:
        UpdataFrquency();
        break;
    case UPDATA_ActPower:
        UpdataActPower();
        break;
    case UPDATA_ReactPower:
        UpdataReactPower();
        break;
    case UPDATA_ApparentPower:
        UpdataApparentPower();
        break;
    case UPDATA_Powerfct:
        UpdataPowerfct();
        break;
    case UPDATA_RTC1:
        if(menustatu.adjust_fg==0)
        {
            UpdataRTC1((unsigned char *)&rtc);                // ʱ
        }
        else
        {
            UpdataRTC1((unsigned char *)&rtc_temp);                // ʱ
        }
        break;
    case UPDATA_RTC2:
        if(menustatu.adjust_fg==0)
        {
            UpdataRTC2((unsigned char *)&rtc);                // ʱ
        }
        else
        {
            UpdataRTC2((unsigned char *)&rtc_temp);                // ʱ
        }
        break;
    case UPDATA_ConsumerdPower:
        UpdataConsumedPower();
        break;
    case UPDATA_ClrPor:
        
    default:
        break;
    }
}